<?php
require '../vendor/autoload.php';

class Asistente
{
    private $asistente_id;
    private $prod_id;
    private $asistente_nombre;
    private $asistente_descripcion;
    private $asistente_codigo;
    private $asistente_activo;
    private $asistente_fec_creacion;

    public function __construct($asistente_id = null)
    {
        global $db;

        try {
            if ($asistente_id != null) {
                $result = $db->Execute("SELECT * FROM tbl_asistente WHERE asistente_id = ?", array($asistente_id));
                if ($result && !$result->EOF) {
                    $fields = $result->fields;
                    $this->asistente_id = $fields['asistente_id'];
                    $this->prod_id = $fields['prod_id'];
                    $this->asistente_nombre = $fields['asistente_nombre'];
                    $this->asistente_descripcion = $fields['asistente_descripcion'];
                    $this->asistente_codigo = $fields['asistente_codigo'];
                    $this->asistente_activo = $fields['asistente_activo'];
                    $this->asistente_fec_creacion = $fields['asistente_fec_creacion'];
                }
            }
        } catch (Exception $e) {
            error_log("Error al inicializar el asistente: " . $e->getMessage());
        }
    }
    public function obtenerProductoAsistente($licencia_id)
    {
        global $db;
        $asistentes = [];
        try {
            $sql = "SELECT a.asistente_id, a.asistente_nombre, a.asistente_codigo, a.asistente_activo 
                    FROM tbl_producto_asistente_licencia pa 
                    INNER JOIN tbl_productos p ON p.prod_id = pa.prod_id
                    INNER JOIN tbl_licencia l ON l.licencia_id = pa.licencia_id
                    INNER JOIN tbl_asistentes a ON pa.asistente_id = a.asistente_id
                    WHERE l.`licencia_id` = ?
                    AND a.asistente_activo = '1'
                    AND l.licencia_activo = '1'
                    AND p.prod_activo = '1'";
            $result = $db->Execute($sql, array($licencia_id));
            if ($result) {
                while (!$result->EOF) {
                    $asistentes[] = $result->fields;
                    $result->MoveNext();
                }
            }
        } catch (Exception $e) {
            error_log("Error al obtener productos asistentes: " . $e->getMessage());
        }
        return $asistentes;
    }
    // Getters and Setters
    public function getAsistenteId()
    {
        return $this->asistente_id;
    }
    public function setAsistenteId($asistente_id)
    {
        $this->asistente_id = $asistente_id;
    }

    public function getProdId()
    {
        return $this->prod_id;
    }
    public function setProdId($prod_id)
    {
        $this->prod_id = $prod_id;
    }

    public function getAsistenteNombre()
    {
        return $this->asistente_nombre;
    }
    public function setAsistenteNombre($asistente_nombre)
    {
        $this->asistente_nombre = $asistente_nombre;
    }

    public function getAsistenteDescripcion()
    {
        return $this->asistente_descripcion;
    }
    public function setAsistenteDescripcion($asistente_descripcion)
    {
        $this->asistente_descripcion = $asistente_descripcion;
    }

    public function getAsistenteCodigo()
    {
        return $this->asistente_codigo;
    }
    public function setAsistenteCodigo($asistente_codigo)
    {
        $this->asistente_codigo = $asistente_codigo;
    }

    public function getAsistenteActivo()
    {
        return $this->asistente_activo;
    }
    public function setAsistenteActivo($asistente_activo)
    {
        $this->asistente_activo = $asistente_activo;
    }

    public function getAsistenteFecCreacion()
    {
        return $this->asistente_fec_creacion;
    }
    public function setAsistenteFecCreacion($asistente_fec_creacion)
    {
        $this->asistente_fec_creacion = $asistente_fec_creacion;
    }
}
