<?php

require '../config/jwt_config.php';

class JWT {
    public static function create($payload) {
        $header = json_encode(['typ' => 'JWT', 'alg' => 'HS256']);

        $payload['exp'] = time() + JWT_EXPIRATION_TIME;

        $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));
        $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode(json_encode($payload)));

        $signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, JWT_SECRET, true);
        $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));

        return $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;
    }

    public static function verify($token) {
        $parts = explode('.', $token);

        if (count($parts) !== 3) {
            return false;  // Token no válido
        }

        $base64UrlHeader = $parts[0];
        $base64UrlPayload = $parts[1];
        $signatureProvided = $parts[2];

        // Crear la firma
        $signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, JWT_SECRET, true);
        $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));

        // Verificar si la firma es válida
        if ($base64UrlSignature !== $signatureProvided) {
            return false;  // La firma no coincide
        }

        $payload = json_decode(base64_decode($base64UrlPayload), true);

        if ($payload['exp'] < time()) {
            return false;  // Token expirado
        }

        return $payload;  // Token válido, devuelve el payload
    }
}
