<?php
require '../vendor/autoload.php';
require_once __DIR__ . '/Asistente.php';
class Producto
{
    private $prod_id;
    private $tipo_prod_id;
    private $prod_nombre;
    private $prod_descripcion;
    private $prod_activo;
    private $prod_fec_creacion;
    private $prod_url;
    private $respuesta = [
        'id_licencia' => null,
        'id_plan' => null,
        'nombre_plan' => null,
        'descripcion_plan' => null,
        'productos' => []
    ];
    public function __construct($prod_id = null)
    {
        global $db;

        try {
            if ($prod_id != null) {
                $result = $db->Execute("SELECT * FROM tbl_producto WHERE prod_id = ?", array($prod_id));
                if ($result && !$result->EOF) {
                    $fields = $result->fields;
                    $this->prod_id = $fields['prod_id'];
                    $this->tipo_prod_id = $fields['tipo_prod_id'];
                    $this->prod_nombre = $fields['prod_nombre'];
                    $this->prod_descripcion = $fields['prod_descripcion'];
                    $this->prod_activo = $fields['prod_activo'];
                    $this->prod_fec_creacion = $fields['prod_fec_creacion'];
                    $this->prod_url = $fields['prod_url'];
                }
            }
        } catch (Exception $e) {
            error_log("Error al inicializar el producto: " . $e->getMessage());
        }
    }
    public function listarProductosPorPlan($plan_id)
    {
        global $db;
        try {
            $sql = "SELECT pp.prod_plan_id, l.licencia_id, p.plan_id, prod.prod_id, p.plan_nombre, p.plan_descripcion, prod.prod_nombre, prod.prod_url, prod.prod_icon, prod.tipo_prod_id, tp.tipo_prod_nombre 
                    FROM `tbl_producto_plan` pp
                    INNER JOIN tbl_plan p ON p.`plan_id` = pp.plan_id
                    INNER JOIN tbl_licencia l ON l.`plan_id` = p.`plan_id`
                    INNER JOIN `tbl_productos` prod ON prod.prod_id = pp.prod_id
                    INNER JOIN `tbl_tipo_producto` tp ON tp.`tipo_prod_id` = prod.`tipo_prod_id`
                    WHERE p.plan_id = ?
                    AND p.`plan_activo` = '1'
                    AND l.`licencia_activo` = '1'
                    AND prod.prod_activo = '1'
                    ";
            $result = $db->Execute($sql, array($plan_id));
            while (!$result->EOF) {
                $fields = $result->fields;

                // Establecer datos de licencia y plan si aún no se han establecido
                if ($this->respuesta['id_licencia'] === null) {
                    $this->setLicenciaPlanData($fields);
                }

                $this->addProducto($fields);
                $result->MoveNext();
            }
        } catch (Exception $e) {
            error_log("Error al obtener la lista de productos por plan: " . $e->getMessage());
        }
        return $this->respuesta;
    }
    private function setLicenciaPlanData($fields)
    {
        $this->respuesta['id_licencia'] = $fields['licencia_id'];
        $this->respuesta['id_plan'] = $fields['plan_id'];
        $this->respuesta['nombre_plan'] = $fields['plan_nombre'];
        $this->respuesta['descripcion_plan'] = $fields['plan_descripcion'];
    }

    private function addProducto($fields)
    {
        $producto = [
            'id_producto_plan' => $fields['prod_plan_id'],
            'id_producto' => $fields['prod_id'],
            'nombre_producto' => $fields['prod_nombre'],
            'url_producto' => $fields['prod_url'],
            'icono' => $fields['prod_icon'],
            'id_tipo_producto' => $fields['tipo_prod_id'],
            'nombre_tipo_producto' => $fields['tipo_prod_nombre'],
            'asistentes' => []
        ];

        if ($fields['tipo_prod_id'] == 2) {
            $asistente = new Asistente();
            $producto['asistentes'] = $asistente->obtenerProductoAsistente($fields['licencia_id']);
        }

        $this->respuesta['productos'][] = $producto;
    }
    // Getters and Setters
    public function getProdId()
    {
        return $this->prod_id;
    }
    public function setProdId($prod_id)
    {
        $this->prod_id = $prod_id;
    }

    public function getTipoProdId()
    {
        return $this->tipo_prod_id;
    }
    public function setTipoProdId($tipo_prod_id)
    {
        $this->tipo_prod_id = $tipo_prod_id;
    }

    public function getProdNombre()
    {
        return $this->prod_nombre;
    }
    public function setProdNombre($prod_nombre)
    {
        $this->prod_nombre = $prod_nombre;
    }

    public function getProdDescripcion()
    {
        return $this->prod_descripcion;
    }
    public function setProdDescripcion($prod_descripcion)
    {
        $this->prod_descripcion = $prod_descripcion;
    }

    public function getProdActivo()
    {
        return $this->prod_activo;
    }
    public function setProdActivo($prod_activo)
    {
        $this->prod_activo = $prod_activo;
    }

    public function getProdFecCreacion()
    {
        return $this->prod_fec_creacion;
    }
    public function setProdFecCreacion($prod_fec_creacion)
    {
        $this->prod_fec_creacion = $prod_fec_creacion;
    }

    public function getProdUrl()
    {
        return $this->prod_url;
    }
    public function setProdUrl($prod_url)
    {
        $this->prod_url = $prod_url;
    }
}
