<?php
use Slim\Http\Request;
use Slim\Http\Response;

require __DIR__ . '/../class/Licencia.php';
require __DIR__ . '/../class/Plan.php';
require __DIR__ . '/../class/Producto.php';
class LicenciaController
{
    public function datosLicencia(Request $request, Response $response)
    {
        // Obtener el payload del token desde el objeto $request
        $jwtPayload = $request->getAttribute('jwt_payload');
        $id_licencia = $jwtPayload['licencia'];
        $id_plan = $jwtPayload['plan'];
        $licencia = new Licencia($id_licencia);

        try {
            if ($licencia->getLicenciaId() > 0) {
                if (filter_var($licencia->getLicenciaActivo(), FILTER_VALIDATE_BOOLEAN)) {
                    // Busco los productos del plan de la licencia
                    $producto = new Producto();
                    $productosData = $producto->listarProductosPorPlan($id_plan);
                    //estado licencia
                    $fechaTermino = $licencia->getLicenciaFecTermino();
                    $fechaActual = new DateTime();
                    $fechaTermino = new DateTime($fechaTermino); 
                    // Verificar si la licencia ha caducado 
                    $licenciaCaducada = $fechaTermino < $fechaActual;
                    $data = [
                        'licencia' => [
                            'id_licencia' => $licencia->getLicenciaId(),
                            'licencia_activa' => $licencia->getLicenciaActivo(),
                            'api_key' => $licencia->getLicenciaApiKey(),
                            'fecha_inicio_licencia' => $licencia->getLicenciaFecInicio(),
                            'fecha_termino_licencia' => $licencia->getLicenciaFecTermino(),
                            'LicenciaCaducada' => $licenciaCaducada
                            // Puedes añadir más atributos de licencia aquí
                        ],
                        'plan' => $productosData
                    ];
                    return buildResponse($response, $data, 200); // OK
                } else {
                    $data = ['error' => 'Su licencia se encuentra expirada'];
                    return buildResponse($response, $data, 401); // Unauthorized
                }
            } else {
                $data = ['error' => 'No existe una licencia válida'];
                return buildResponse($response, $data, 401); // Unauthorized
            }
        } catch (Exception $e) {
            $data = ['error' => 'Se produjo un error interno: ' . $e->getMessage()];
            return buildResponse($response, $data, 500); // Internal Server Error
        }
    }

    

}
