<?php
use Slim\Http\Request;
use Slim\Http\Response;

require __DIR__ . '/../class/Usuario.php';
class UsuarioController
{
    public function login(Request $request, Response $response)
    {
        $username = $request->getParam('username');
        $password = $request->getParam('password');

        $usuario = new Usuario();

        try {
            if ($usuario->authenticate($username, $password)) {
                $token = $usuario->generateToken();
                $data = [
                    'nombres' => $usuario->getUsuNombres(),
                    'apellidos' => $usuario->getUsuApellidos(),
                    'email' => $usuario->getUsuEmail(),
                    'institucion' => $usuario->getInstitucionNombre(),
                    'ciudad' => $usuario->getInstCiu(),
                    'pais' => $usuario->getInstPais(),
                    'token' => $token
                ];
                return buildResponse($response, $data, 200); // OK
            } else {
                $data = ['error' => 'Credenciales incorrectas'];
                return buildResponse($response, $data, 401); // Unauthorized
            }
        } catch (Exception $e) {
            $data = ['error' => 'Se produjo un error interno: ' . $e->getMessage()];
            return buildResponse($response, $data, 500); // Internal Server Error
        }
    }
    
    public function verificar(Request $request, Response $response)
    {

        $jwtPayload = $request->getAttribute('jwt_payload');
        $id_licencia = $jwtPayload['licencia'];
        $licencia = new Licencia($id_licencia);

        try { 
            $fechaTermino = $licencia->getLicenciaFecTermino();
            $fechaActual = new DateTime();
            $fechaTermino = new DateTime($fechaTermino);

            // Verificar si la licencia ha caducado 
            $licenciaCaducada = $fechaTermino < $fechaActual;

            $data = [
                'estado' => $licenciaCaducada ? false : true
            ];
            return buildResponse($response, $data, 200); // OK
        } catch (Exception $e) {
            $data = ['error' => 'Se produjo un error interno: ' . $e->getMessage()];
            return buildResponse($response, $data, 500); // Internal Server Error
        }


    }

}
